/**
 * @file    ExternalDependencyConst.cs
 * 
 * @author  jschoi
 * @date    2024~
 * @copyright Copyright © Com2uS Platform Corporation. All Right Reserved.
 * @defgroup Hive.Unity.Editor
 * @{
 * @brief HIVE External Dependency Const <br/><br/>
 */

using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEditor;
using System;
using System.IO;
using System.ComponentModel;
using System.Reflection;
using System.Xml;

namespace Hive.Unity.Editor
{
    public class ExternalDependencyConst
    {
        // Hive Dependencies Editor 설정 저장 파일 (SaveFile), Hive 23.4.0 이상, xml 파일
        public static readonly string projSettingsXmlDataPath = Path.Combine(Application.dataPath, "../ProjectSettings/HiveDependencies.xml");

        // 구 Hive Dependencies Editor 설정 저장 파일 (SaveFile), Hive 23.0.0 이상 ~ 23.4.0 미만, json 파일
        public static readonly string projSettingsJsonDataPath = Path.Combine(Application.dataPath, "../ProjectSettings/HiveExternalDependencyDictionary.json");

        // 구 Hive Dependencies Editor 설정 저장 파일 (SaveFile), Hive 4.16.1 이상 ~ 23.0.0 미만, json 파일
        public static readonly string jsonDataPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor/ExternalDependency/externalDependencyDictionary.json");

        // 구 Hive Dependencies Editor 설정 저장 파일 (SaveFile), Hive 4.16.1 미만, json 파일
        public static readonly string legacyJsonDataPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor/externalDependencyDictionary.json");


        // Hive_SDK_v4/Editor 경로
        public static readonly string editorPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor");
        // Hive_SDK_v4/Dependencies 경로
        public static readonly string dependenciesPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Dependencies");

        // AndroidSamplePostBuildProcess 파일 (샘플 파일 존재 여부 확인용)
        public static readonly string sampleFilePath = Path.Combine(Application.dataPath, "SampleBuilder/Editor/AndroidSamplePostBuildProcessor.cs");

        // HiveSDK 와 관련해 설정한 모든 디펜던시를 선언한 xml 파일
        public static readonly string hiveDependenciesXmlPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor/HiveSDKSettingsDependencies.xml");

        // HiveSDK Unity 패키지에서 디폴트 설정으로 전달되는 디펜던시 xml 파일 (각 Android, iOS 패키지 설치 시 들어오는 파일)
        public static readonly string hiveAndroidDependenciesTempXmlPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor/TempHiveSDKAndroidSettingsDependencies.xml");
        public static readonly string hiveiOSDependenciesTempXmlPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Editor/TempHiveSDKiOSSettingsDependencies.xml");

        // Platform Version Json 파일 경로
        public static readonly string hiveAndroidVersionJsonPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Version/HiveSDKPlatformAndroidVersion.json");
        public static readonly string hiveiOSVersionJsonPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Version/HiveSDKPlatformiOSVersion.json");
        public static readonly string hiveWindowsVersionJsonPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Version/HiveSDKPlatformWindowsVersion.json");
        public static readonly string hiveInterfaceVersionJsonPath = Path.Combine(Application.dataPath, "Hive_SDK_v4/Version/HiveSDKInterfaceVersion.json");

        // 인터페이스 버전 파일 구조화
        [System.Serializable]
        public class VersionFileInfo
        {
            public string type;
            public string os;
            public string version;
        }

        // 인터페이스 버전 정보 획득
        // - 1단계 상위에 있는 HiveSDKInterfaceVersion.json 파일에서 "version" 키의 값을 반환합니다.
        public static string getInterfaceDependencyVersion()
        {
            if(File.Exists(ExternalDependencyConst.hiveInterfaceVersionJsonPath))
            {
                try
                {
                    var json = System.IO.File.ReadAllText(ExternalDependencyConst.hiveInterfaceVersionJsonPath);
                    var versionFileInfo = JsonUtility.FromJson<VersionFileInfo>(json);
                    return versionFileInfo.version;
                }
                catch (Exception e)
                {
                    return "";
                }
            }
            return "";
        }

        // 플랫폼 Android 버전 정보 획득
        public static string getAndroidDependencyVersion()
        {
            if(File.Exists(ExternalDependencyConst.hiveAndroidVersionJsonPath))
            {
                try
                {
                    var json = System.IO.File.ReadAllText(ExternalDependencyConst.hiveAndroidVersionJsonPath);
                    var versionFileInfo = JsonUtility.FromJson<VersionFileInfo>(json);
                    return versionFileInfo.version;
                }
                catch (Exception e)
                {
                    return "";
                }
            }
            return "";
        }

        // 플랫폼 iOS 버전 정보 획득
        public static string getiOSDependencyVersion()
        {
            if(File.Exists(ExternalDependencyConst.hiveiOSVersionJsonPath))
            {
                try
                {
                    var json = System.IO.File.ReadAllText(ExternalDependencyConst.hiveiOSVersionJsonPath);
                    var versionFileInfo = JsonUtility.FromJson<VersionFileInfo>(json);
                    return versionFileInfo.version;
                }
                catch (Exception e)
                {
                    return "";
                }
            }
            return "";
        }
    }
}
